class twitch::haproxy::listeners::livebeta_port_1935 (
  $haproxy_instance = 'livebeta',
  $proxy_name     = 'livebeta-port_1935',
  $servers        = [
    'ingest3-1.sfo01.justin.tv',
  ],
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = $::ipaddress,
  $server_options = 'check port 9393 inter 10s',
  $settings       = {
    'maxconn' => '32000',
    'option'  => [
      'httpchk GET / HTTP/1.0\n\n',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
