class twitch::haproxy::listeners::private_port_1935 (
  $haproxy_instance = 'private',
  $proxy_name     = 'private-port_1935',
  $servers        = [
    'ingest1.sfo01.justin.tv',
    'ingest17.sfo01.justin.tv',
    'ingest33.sfo01.justin.tv',
    'ingest49.sfo01.justin.tv',
  ],
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = '0.0.0.0',
  $server_options = 'check port 9393 inter 5000',
  $settings       = {
    'log'     => 'global',
    'balance' => 'leastconn',
    'option'  => [
      'httpchk GET / HTTP/1.0\n\n',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
