class twitch::haproxy::listeners::tolive_port_1935 (
  $haproxy_instance = 'tolive',
  $proxy_name     = 'tolive-port_1935',
  $servers        = [
    'live1.sfo01.justin.tv',
    'live6.sfo01.justin.tv',
    'live7.sfo01.justin.tv',
    'live8.sfo01.justin.tv',
    'live11.sfo01.justin.tv',
    'live12.sfo01.justin.tv',
    'live13.sfo01.justin.tv',
    'live14.sfo01.justin.tv',
    'live20.sfo01.justin.tv',
    'live21.sfo01.justin.tv',
    'live22.sfo01.justin.tv',
    'live23.sfo01.justin.tv',
    'live24.sfo01.justin.tv',
    'live25.sfo01.justin.tv',
    'live26.sfo01.justin.tv',
    'live27.sfo01.justin.tv',
    'live28.sfo01.justin.tv',
    'live29.sfo01.justin.tv',
    'live30.sfo01.justin.tv',
    'live31.sfo01.justin.tv',
    'live32.sfo01.justin.tv',
    'live33.sfo01.justin.tv',
    'live34.sfo01.justin.tv',
    'live35.sfo01.justin.tv',
  ],
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = '127.0.0.1',
  $server_options = 'check',
  $settings       = {
    'clitimeout' => '12000',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
