class twitch::haproxy::listeners::toprivate_port_1935 (
  $haproxy_instance = 'toprivate',
  $proxy_name     = 'toprivate-port_1935',
  $servers        = [
    'live1.sfo01.justin.tv',
  ],
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = $::ipaddress_bond0_1,
  $server_options = 'check',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
