class twitch::haproxy::listeners::usher_find_usher (
  $haproxy_instance = 'usher',
  $proxy_name     = 'find_usher',
  $servers        = [
    'find1.sfo01.justin.tv:8000',
    'find2.sfo01.justin.tv:8000',
    'find3.sfo01.justin.tv:8000',
    'find4.sfo01.justin.tv:8000',
    'find5.sfo01.justin.tv:8000',
    'find6.sfo01.justin.tv:8000',
    'find7.sfo01.justin.tv:8000',
    'find10.sfo01.justin.tv:8000',
    'find11.sfo01.justin.tv:8000',
    'find12.sfo01.justin.tv:8000',
    'find13.sfo01.justin.tv:8000',
    'find14.sfo01.justin.tv:8000',
    'find15.sfo01.justin.tv:8000',
    'find16.sfo01.justin.tv:8000',
    'find17.sfo01.justin.tv:8000',
  ],
  $listen_port    = 8095,
  $remote_port    = 8925,
  $listen_address = '0.0.0.0',
  $server_options = 'check port 8001 inter 2000 maxconn 200',
  $settings       = {
    'maxconn'    => '52000',
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'roundrobin',
    'clitimeout' => '180000',
    'srvtimeout' => '180000',
    'contimeout' => '5000',
    'option'     => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /alive HTTP/1.0',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
