class twitch::haproxy::listeners::usher_port_80 (
  $haproxy_instance = 'usher',
  $proxy_name     = 'port_80',
  $servers        = [
    'usher16.justin.tv:8000',
    'usher17.justin.tv:8000',
    'usher18.justin.tv:8000',
    'usher19.justin.tv:8000',
    'usher20.justin.tv:8000',
    'usher21.justin.tv:8000',
    'usher22.justin.tv:8000',
    'usher23.justin.tv:8000',
    'usher24.justin.tv:8000',
    'usher25.sfo01.justin.tv:8000',
    'usher26.sfo01.justin.tv:8000',
    'usher998.sfo01.justin.tv:8000',
  ],
  $listen_port    = 8080,
  $remote_port    = 8925,
  $listen_address = '0.0.0.0',
  $server_options = 'check port 8001 inter 1000 maxconn 200',
  $settings       = {
    'maxconn'    => '52000',
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'roundrobin',
    'clitimeout' => '180000',
    'srvtimeout' => '180000',
    'contimeout' => '5000',
    'option'     => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /alive HTTP/1.0',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
