# TODO: remove when dirty machines are gone (not used for clean)
class twitch::haproxy::listeners::web_appcache (
  $haproxy_instance = 'web',
  $proxy_name     = 'appcache',
  $servers        = [
  ],
  $listen_port    = 6650,
  $remote_port    = 6081,
  $listen_address = '0.0.0.0',
  $server_options = 'check inter 5000',
  $settings       = {
    'maxconn'   => 32000,
    'log'       => 'global',
    'balance'   => 'uri whole',
    'mode'      => 'http',
    'hash-type' => 'map-based',
    'option'    => [
      'httplog',
      'dontlog-normal',
      'dontlognull',
      'forceclose',
      'http-server-close'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
