class twitch::haproxy::listeners::web_jtvapp (
  $haproxy_instance = 'web',
  $proxy_name     = 'jtvapp',
  $servers        = [
    '10.1.12.96',
  ],
  $listen_port    = 3900,
  $remote_port    = 666,
  $listen_address = '0.0.0.0',
  $server_options = 'check inter 5000 weight 24',
  $settings       = {
    'maxconn'        => 32000,
    'log'            => 'global',
    'balance'        => 'roundrobin',
    'mode'           => 'tcp',
    'clitimeout'     => '180000',
    'srvtimeout'     => '180000',
    'contimeout'     => '5000',
    'option'         => [
      'httplog',
      'dontlog-normal',
      'dontlognull',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
