class twitch::haproxy::listeners::web_kraken (
  $haproxy_instance = 'web',
  $proxy_name     = 'kraken',
  $servers        = [],
  $listen_port    = 4000,
  $remote_port    = 7000,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000 weight 24',
  $settings       = {
    'maxconn'        => 32000,
    'log'            => 'global',
    'balance'        => 'leastconn',
    'mode'           => 'http',
    'clitimeout'     => '150000',
    'srvtimeout'     => '30000',
    'contimeout'     => '60000',
    'cookie'         => '_jtv2_session_id prefix',
    'default-server' => 'maxconn 8 fall 1 rise 1 maxqueue 1',
    'timeout'        => [
      'queue 5000ms'
    ],
    'option'         => [
      'httplog',
      'dontlog-normal',
      'dontlognull',
      'http-server-close',
      'forwardfor',
      'abortonclose',
      'httpchk HEAD /running/index HTTP/1.0',
      'redispatch',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
