class twitch::haproxy::listeners::web_ssl_termination (
  $haproxy_instance = 'web',
  $proxy_name     = 'ssl_termination',
  $servers        = ['localhost'],
  $listen_port    = "443",
  $bind_options   = ["ssl crt /etc/ssl/certs/wildcard.jtvnw.net.combined.haproxy.pem crt /etc/ssl/certs/wildcard.twitch.tv.combined.haproxy.pem"],
  $remote_port    = 80,
  $listen_address = $::ipaddress,
  $server_options = 'check inter 5000',
  $settings       = {
    'mode'   => 'http',
    'reqadd' => [
      'HTTP-FRONT-END-HTTPS:\ true',
      'X-ClientProtocol:\ https',
    ],
    'option' => [
      'forwardfor header X-TTVLB-Client-IP',
    ],
  },
) {
  include twitch::haproxy_sslcerts

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
    bind_options        => $bind_options,
  }
}
