class twitch::haproxy::listeners::web_steam (
  $haproxy_instance = 'web',
  $proxy_name     = 'steam',
  $servers        = [
    'discovery-a0c34c.sfo01.justin.tv',
    'discovery-a0c35a.sfo01.justin.tv',
  ],
  $listen_port    = 12110,
  $remote_port    = 9000,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
