class twitch::haproxy::services::owl (
  $listen_port       = 12280,
  $consul_tag_filter = "clean-production",
) {
  include twitch::haproxy::backend

  twitch_haproxy::consul_listen { 'owl':
    config_target       => $twitch::haproxy::backend::config_target,
    ipaddress           => '127.0.0.1',
    ports               => $listen_port,
    consul_services     => consul_service_lookup('owl', {'dc'=>'sfo01','tag'=>$consul_tag_filter}),
    server_options      => 'check inter 5000',
    options             => {},
  }
}
