class twitch::haproxy::services::rails(
  $consul_tag_filter = "clean-production",
  $http_host         = "api.internal.twitch.tv",
) {
  include twitch::haproxy::backend

  $proxyname = "rails-api"
  $port      = 4040

  twitch_haproxy::frontend { $proxyname:
    ports         => [$port],
    ipaddress     => ['127.0.0.1'],
    config_target => $twitch::haproxy::backend::config_target,
    options       => {
      'default_backend' => $proxyname,
      'mode'            => 'http',
      'reqidel'         => '^Host:.*',
      'reqadd'          => "Host:\ ${http_host}",
    },
  }

  twitch_haproxy::consul_backend { $proxyname:
    config_target   => $twitch::haproxy::backend::config_target,
    consul_services => consul_service_lookup("web-rails-nginx", {'dc'=>'sfo01','tag'=>$consul_tag_filter}),
    server_template => "${module_name}/haproxy/services/rails_servers.erb",
    server_options  => "fall 1 rise 2 check inter 5000 maxconn 5000",
    options         => {
      'mode'    => 'http',
      'maxconn' => '100000',
      'option'  => [
        "httpchk HEAD /running HTTP/1.1\\r\\nHost:\ ${http_host}",
        'http-server-close',
      ],
    },
    prefer_localhost => false,
  }
}
