class twitch::haproxy::toprivate (
  $instname   = 'toprivate',
  $stats_port = 2001,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-toprivate.pid',
    'maxconn'      => '4000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_toprivate',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-toprivate.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'allbackups',
    ],
    'timeout' => [
      'connect 1000',
      'server 5000',
      'client 12000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::listeners::toprivate_port_1935
}
