class twitch::haproxy::usher (
  $instname   = 'usher',
  $stats_port = 2000,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-usher.pid',
    'maxconn'      => '32000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_usher',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-usher.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 5000',
      'server 180000',
      'client 180000'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::listeners::usher_port_80
  include twitch::haproxy::listeners::usher_find_usher
  include twitch::haproxy::listeners::usher_usher_testing
}
