class twitch::haproxy::usher_origin (
  $listen_port = 8000,
  $ports,
  $instname = 'usher-origin',
  $stats_port = 2020,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => "/var/run/haproxy-usher-origin.pid",
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => "haproxy-usher-origin",
    'log'     => '127.0.0.1 local3',
    'stats'   => "socket /var/run/haproxy-usher-origin.stat user root group root mode 666 level operator",
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 5000',
      'server 180000',
      'client 180000'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  if size($ports) / 2 < 1 {
    $min_backends = 1
  } else {
    $min_backends = size($ports) / 2
  }

  class { 'twitch::haproxy::frontends::usher_origin_check':
    instname => $instname,
    min_backends => $min_backends,
  }
  class { 'twitch::haproxy::frontends::usher_origin':
    instname => $instname,
    listen_port => $listen_port,
  }
  class { 'twitch::haproxy::backends::usher_origin':
    instname => $instname,
    ports => $ports,
  }

  consul::service { $instname:
    service_name => $instname,
    consul_tags  => ['haproxy'],
    port         => $listen_port,
  }
}
