class twitch::haproxy::videoshim (
  $instname = 'videoshim',
  $stats_port = 2018,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-videoshim.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '2',
    'log-tag' => 'haproxy_videoshim',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy-videoshim.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 1000',
      'server 10000',
      'client 500'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::frontends::videoshim_check
  include twitch::haproxy::frontends::videoshim
  include twitch::haproxy::backends::videoshim
}
