class twitch::haproxy::web (
  $instname   = 'web',
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-web.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '2',
    'log-tag' => 'haproxy_web',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_web-private.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'mode'    => 'tcp',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 500',
      'server 30000',
      'client 500'
    ]
  },
){

  include twitch::haproxy::listeners::web_discovery
  include twitch::haproxy::listeners::web_steam

  $web_env = hiera('web_env', 'production')
  $deploy_env = hiera('clean', 'false') ? {
    'true' => "clean-${web_env}",
    default => $web_env,
  }

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
  }

  class{ 'twitch::haproxy::listeners::web_rails_varnish':
    servers => consul_service_lookup('web-rails-varnish', {'dc' => $::pop, 'tag' => $deploy_env}),
  }

  class{ 'twitch::haproxy::listeners::web_rails_app':
    servers => consul_service_lookup('web-rails-app', {'dc' => $::pop, 'tag' => $deploy_env}),
  }
}
