class twitch::nginxips (
  $nginx_conf_dir = $twitch_nginx::params::nginx_conf_dir
){

  include twitch_nginx

  file { "${nginx_conf_dir}/ips":
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
    source  => 'puppet:///modules/twitch/nginx/ips/',
    recurse => true,
    require => Class['twitch_nginx::config_dirs']
  }

  file { "${nginx_conf_dir}/vips":
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
    source  => 'puppet:///modules/twitch/nginx/vips/',
    recurse => true,
    require => Class['twitch_nginx::config_dirs']
  }
}
