class twitch::packages {

  $installed_packages = [
    'bc',
    'bison',
    'build-essential',
    'debconf-utils',
    'ethtool',
    'flex',
    'fping',
    'graphviz',
    'ipmitool',
    'jq',
    'libcap2-bin',
    'libevent-dev',
    'libfaac0',
    'libffi-dev',
    'libid3tag0',
    'libjson-spirit-dev',
    'libmp3lame0',
    'libmysqlclient-dev',
    'libpam-http',
    'libpcre3-dev',
    'libreadline-dev',
    'libsasl2-dev',
    'libspeex1',
    'libssl-dev',
    'libvorbisenc2',
    'libxml2-dev',
    'libxslt1-dev',
    'libyaml-dev',
    'logtail',
    'multiwatch',
    'pbuilder',
    'pkg-config',
    'python-protobuf',
    'screen',
    'snmp',
    'socat',
    'spawn-fcgi',
    'subversion',
    'swfmill',
    'tmux',
    'unzip',
    'xfsprogs',
  ]

  $default_packages = [
    'libmemcached2',
    'libprotobuf7',
  ]

  $trusty_packages = [
    'libmemcached10',
    'libprotobuf8',
  ]
  $gem_packages = [
    'activerecord',
    'activerecord-mysql-adapter',
  ]

  @package { $installed_packages:
    ensure  => 'installed',
    tag     => 'virtual',
    require => Exec['apt_update']
  }

  case $::lsbdistcodename {
    'trusty': {
      @package { $trusty_packages:
        ensure => 'installed',
        tag    => 'virtual',
      }
    }
    default: {
      @package { $default_packages:
        ensure => 'installed',
        tag    => 'virtual',
      }
    }
  }
  @package {$gem_packages:
    ensure   => 'installed',
    tag      => 'virtual',
    provider => 'gem',
  }

  # python packages
  @package { 'mixpanel-py':
    provider => 'pip',
    tag      => 'virtual',
    require  => Exec['apt_update']
  }
}
