class twitch::robots (
){
  include twitch_nginx

  $html_dir = $twitch_nginx::params::nginx_html_dir
  validate_absolute_path($html_dir)

  $robot_source = $cluster ? {
    'media' => 'puppet:///modules/twitch/null',
    default => 'puppet:///modules/twitch/nginx/robots.txt',
  }

  file{ "${html_dir}/robots.txt":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => $robot_source,
    require => Class['twitch_nginx::install']
  }
}
