class twitch::sites::config::twitchtv_acl (
  $conf_dir   = $twitch_nginx::params::nginx_conf_dir,
  $acl_source = $cluster,
){
  validate_absolute_path($conf_dir)

  include twitch_nginx

  file { "${conf_dir}/twitchtv_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/twitch/nginx/nginx_${acl_source}_acl.conf",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
