class twitch::sites::config::upstream_discovery (
  $svc_name        = 'twitchtv',
  $nginx_vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
  $upstream_port   = 3502
){

  validate_string($svc_name)
  validate_absolute_path($nginx_vhost_dir)
  validate_re($upstream_port,'\d+')

  include twitch_nginx

  file{ "${nginx_vhost_dir}/upstream_discovery.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/nginx/upstream_discovery.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
