class twitch::sites::config::upstream_kraken (
  $nginx_vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
  $upstream_port = 2200
){

  validate_re($upstream_port, '\d+')
  validate_string($nginx_vhost_dir)

  include twitch_nginx

  file{ "${nginx_vhost_dir}/upstream_kraken.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/nginx/upstream_kraken.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
