class twitch::sites::config::upstream_newjtv (
  $nginx_vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
  $upstream_port = 3900
){

  $validate_upstream_port = is_numeric($upstream_port)
  validate_bool($validate_upstream_port)

  include twitch_nginx

  file{ "${nginx_vhost_dir}/upstream_newjtv.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/nginx/upstream_newjtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
