class twitch::sites::config::web {
  include twitch_nginx

  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir

  file{ "${vhost_dir}/web.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitch/nginx/web.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
