# Location to define virtual ssh pub keys to be added to a user's authorized_keys file.
# The keys are written from users::authorizedkey define and uses the native puppet
# resource ssh_authorized_key
class twitch::sshkeys::authorizedkeys {

  @ssh_authorized_key { 'deploy_pubkey':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQCj4lS0mjSIxVVMkSMvKH1QG6CRqZ2DrdU0OnpvWaLWveMaMT52JNprSErgj/UF8y6Q9+twUJKzfCU8KOEs7mKvgi9iW2vajqitABlulvVkuBmZwE43m7yi2l7vAr8hBUHrILR2GUNjTp4e/yt5fBQw7YkZ2RjzusVrClH1GFfzPOvly0kNmm+ZmMuhS790bqXsVP7AioPVP5Q13seJhjVPxQGkp53bOelCFpVpt7nHZULj+3q7LdU5IcFmDcH33/G/Op9gfe94JfUWp/7fCfvrypmj/ni7AxXnYFYxcni6e7Eo2qAL6XNXCNdQgjTipPkW37uJCZCDrqqp4fUj1M+H+nZSlGM+b0mReqDZVQzfFNMpji/oFLQY2UUKRTHDEoInFwBM9aAx5LxCuXty2p6cWDiB7s16ctgq4GWHlHQRzz4wd6rN8Kp7lgxu4z35eUjPx4f3ILlGXUbqyhpY6/ZMT8PJ3GdyaGSnVrPq05zA9/liN+bNczkwCtXMcSa3GImOal7lSJgX7/UPxai3/IT6r772qqIVsgvIHIyuWIt0OanmFax6Jz4rgIxQexQXoZwLJTBmiPCRpWgjrb9SzkgPI1kLP/cxaljvxcYJab+Vpc8Cw9uCrcVZTerF1rZcGqJfIVTpkJX0SBRsH7GTJPehopEcf8wIwEmcuGk/lm1yyw==',
  }

  @ssh_authorized_key { 'discovery_barman':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQDsGiQJqVtY+/kqGI4ZFua73GduI1UD2P8YJEY8LYe7Ub5q/mrsFrM/71waKJYACR1AWWwq8Qgl9Uv+TRFnLmE3040Bxa/HFoNPACj13ViZpSqBYk6jxwXBJuQaiNoIlquOiPNTGvn04BR4HtbJZJtjj8FhvlOQa1pr0iwAC6SbOaWYSw84TZQD12NLGVsNB81iA7iE84IepZbNT9GrOGAA8GsJzCBd4BEuGdjSQXFOVVYFcF3v7Wq+WfyQxMnyJyD8TNrLsSufdcvW6SAiSMq8vORdysFjTt9NeWEp1iFkB8bN3av7R2TLK0j+mLQnkXaC3ABybF8iwn/Gz/d9IYIsHkrxHBFQKa5hvClpOGOAUw5WecGA7/LRhyM6ydad3Is6VO17XXDQdyP68cTtutVjEBqHLb3wVPUnhDmDsoyiDhg2g8RmFAMB5E8lYHEBVLv7Lz3phstglqn0+YSD+QrBAFB0882r+BycXgeANFzxIxajyxYk5BG6LDo9dl83F/HBps5iZXrgF+gZiS7Ce91hayGotAWH3RoDi3+tIVmwozo6Xtgx2O7hzIj/IuxIh6xDYzfNa/QKQIbBFpqmDm+Y5zCllTA0Hkh8yATAAxGtzYnbCtoBjxYSyqWPuXci9wnpyZX3byavhl5ne37pZsr5GuqB4eOVmUTZW60nmZGboQ==',
  }

  @ssh_authorized_key { 'discovery_postgres':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQDjNBzVg6mDUtkVZfWDMS94ommF+lV8r9ml2rNNvYwIS/NKp5IawSybjGw7ckT20/3Q10eeAAtOKQZBcqREa1rHCifaurEEkjwrWUfVSkUgZgusRqAlz6xyopt/QoWB60FyZ2sjVEizLBeCkbURuvUD33pAVd6L1sw0IDKJbVAcehBYYpvzYt6FI1e5whSyxa5yKHq2cZ8wEVz1o10t8xtGQEpQFHafPSJBaLAaUwIipkTPK/UNmQmN1UbVUU1YmGgGYwM5NIYA5vwEe4j9cmWcTekE+y7qtTbRsg1nMEzWwNU+PT36VBR2uDXrkcOIyxlhaLYoyPGtn9SbzE4kXhEdQmtjv8ITIg15YZLG2r4RRf7QXbsgrxmcdYRqwz46WFubD1Rv/LAtIhqmp+WRkhe1Jp+S7BWNzBmFjQbLk6mhomIKTYkPOJrMPTnq0a6JL0YSOZqFsndQz1c1Aw8/YKHErDi4IR62EZ9V8xiUTJLc7QfHyjA3x882+GB2bShc9/tNL4gvj2l2yQCne434KVenzfDYhmetA/q2X1cuO8GU7XLN2ScS165CAkuuIEaQePyP6T2G4QzM1LOWVe8QxRr3c+txJ5UeBOrapQScl2BN20v0DwxvDIDGn5yG86beD0w0CltbwFcc6nLu2RxiFL8M4uOPzOE96KWyhQUjWKXBxw==',
  }

  @ssh_authorized_key { 'sitedb_barman':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQDJG6A5KwqajxR9BTvZdu/aVpL4fMFFbU61yQ3njb+TIwWY4hBATDfJ4aaXZS48H4SALLrFDVBnDuV7Xgegp2WiT2crBa21L6N0Llm805pu4YzScm3i+SeoFSa/AKQMptfhxOPEAN/AKAYvWTNZgCGHaYO1ThGqUW5cFTXeAIBd0fZbwrSMWEZC1WOBoOXyLOK9EmmoE8bytKKiN0NWyWOUxoHPJ9IMJ8d2Nbe2GZbrz4ZSKByqSyKHFU+OjX3MN3gukMnVa/LwQQynVwSGnklUdc0OVFo6boqr3UWGBhwtNcfb5TrtD2GCZ5EYErWQU1gc09O/GtddL/VC5+qgkc9LCRI2N2KzEkv1qBNAGMxaChtDWqrda7aOa5giL+JI9DrfOlk/RMsXGjGKTKqDQfYXLcU994ZGbLJtgTj4H4DE3F3gd+ERfyQoPqCvq3A3HLnpakV4y3qK1SyjEVLh5k8x39jRuFtTsMwEuXZKvDGTdbtdRqoZ6lde6Owujh3OMBRpspAZnKQZ0D7aF/2BzlfBJ2NtmwEM1BBjMPSAk/oL0Djlpp+/wRD1KcmvTDh2NyDq79L0A5cYdLvN57GuI9e+i/WaiP8iW72YDwwVeQMnl6ZG9hBRHnt+FdiQ71kvORAipmNaFhZR6Vmqjll0LzQAgcohvAHuiCBCMtkazJAGPw==',
  }

  @ssh_authorized_key { 'sitedb_postgres':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQDJZWdfFdtzQOFIIwv9UWm2Oti6cYP5LZTr6vJMPqU+2b+4SAwV6wkwJ/40log4sw/hFl2LHW8rMe2TI+ML5CLZrT5lP0S7UWv1WQ8RrFLdDljvxYi4/XNkucDRGCA4Cmdr9HHFp3weJ5fTIx2fUQyWns3UhJgzfq5GoGsoyOwA5RkX3VjXJQ9NStRahIqsAFBNmOpkj4sqdAAKTbSRK1Isjp00+urDEGC9sl5ScIsFhjCYUn9xyriiEPjP/b4bOVnsUXilqDxyzlfVLzmsLf4876lzPUfOMr37I8r3VY/6ahy5qGRpPeUrCK1abSz0PJJP2A/9D5/0rmlTeHyA85kX6VXz8cOgM/GZsLgbQ0TDROirsRzO7Hzjclu9zzf0GqNUfdOAUivFxsuQsWL0w1X5PGxFxk0FDnw542nFfibYL+93RW/s/irqkDWIze8na6fQym9kpStq8h2LmTtmrRf2o7dX6XvFmeb2J9VsEx/jDpxfQXElUIP3vjSbgEg90rkj/PLFu78d08K1TmJGvABpuomC/p4Wyt2PGzRWKwh0p9OEfMeppVDtQcAXG5SqJeOZsa01Y0Nj9uh2n0RAb4sniEsXOfRlv2jjHA8tAyKE8OQ4b8tnhnYyk7zIIzg7hDWGpBfEokO+aEfTMb6h23mX79CJO+wlnn+njAXCJrBzOw==',
  }

}
