# helper to facilitate conventions on paths for ssl certificates
#
# a certificate can be:
#  1. separate public/private pair (most common)
#  2. PEM file encoded with both private and public info
define twitch::ssl_certificate(
  $certificate     = $name,
  $public_cert_dir = '/etc/ssl/certs',
  $private_key_dir = '/etc/ssl/private',
  $suffix          = 'crt',
  $private_key     = undef
) {

  $certificate_file  = "${certificate}.${suffix}"
  $puppet_ssl_source = "puppet:///modules/${module_name}/ssl"
  # include our virtual certificates
  include twitch::sslcerts

  # realize the one we want
  realize(File[$certificate_file])
  # override the attributes of the above resource
  File <| title == $certificate_file |> {
    ensure => 'present',
    path   => "${public_cert_dir}/${certificate_file}",
    owner  => 'root',
    group  => 'root',
    mode   => 0644,
    source => "${puppet_ssl_source}/${certificate_file}",
  }

  if $private_key {
    $private_key_file = "${private_key}.key"
    realize(File[$private_key_file])

    File <| title == $private_key_file |> {
      ensure => 'present',
      path   => "${private_key_dir}/${private_key_file}",
      owner  => 'root',
      group  => 'ssl-cert',
      mode   => 0640,
      source => "${puppet_ssl_source}/${private_key_file}",
    }
  }

}
