class twitch::users::deploy (
  $password              = undef,
  $ssh_authorized_keys   = [],
  $ssh_authorized_keys_default = [
    'deploy_pubkey',
  ],
  $ssh_priv_keys         = [],
  $ssh_priv_keys_default = [],
  $ssh_config_opts       = {}
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  $ssh_authorized_keys_all = flatten([$ssh_authorized_keys_default, $ssh_authorized_keys])
  $ssh_priv_keys_all       = flatten([$ssh_priv_keys_default, $ssh_priv_keys])

  users::create { 'deploy':
    system              => true,
    password            => $password,
    ssh_authorized_keys => unique($ssh_authorized_keys_all),
    ssh_priv_keys       => unique($ssh_priv_keys_all),
    ssh_config_opts     => $ssh_config_opts,
  }

  file{ "/home/deploy/cronscripts":
    ensure  => directory,
    owner   => 'deploy',
    group   => 'deploy',
    mode    => '0755',
    require => Users::Create['deploy']
  }

  sudo::conf { "ttv-deploy_user":
    priority => 99,
    content  => "deploy ALL=(ALL) NOPASSWD:ALL",
  }
}
