class twitch::users::desktagger (
  $password            = undef,
  $home                = '/home/desktagger',
  $ssh_authorized_keys = [
  ],
  $ssh_priv_keys       = [
  ],
  $ssh_config_opts     = {}
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)
  group { 'desktagger':
    ensure => present,
  }
  users::create { 'desktagger':
    home                => $home,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    ssh_config_opts     => $ssh_config_opts,
    gid                 => 'desktagger',
    require             => Group['desktagger'], 
  }
}
