class twitch::users::firehose (
  $password            = '!!',
  $ssh_authorized_keys = [
    'firehose',
  ],
  $ssh_priv_keys       = [
  ],
  $uid                 = '1010',
  $gid                 = '1010',
) inherits twitch::params {
  validate_string($password)
  validate_array($ssh_authorized_keys, $ssh_priv_keys)

  group { 'firehose':
    gid => $gid,
  }

  users::create { 'firehose':
    password            => $password,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    uid                 => $uid,
    gid                 => $gid,
    require             => Group['firehose'],
  }
}
