class twitch::users::jtv (
  $password            = "\$6\$MnozKG9U\$M2eW67FwebjuxD.2jAdBuqHiMXsJgJwK7Nn9qYciAer4VmjSP45WNc5tMi2.9/Jv5KnRRqTmNDnSsKgUjdEdj0",
  $ssh_authorized_keys = [],
  $ssh_config_opts     = $twitch::params::jtv_ssh_config,
) inherits twitch::params {
  validate_string($password)
  validate_array($ssh_authorized_keys)
  validate_hash($ssh_config_opts)

  users::create { 'jtv':
    password        => $password,
    ssh_config_opts => $ssh_config_opts,
  }

  file{ "/home/jtv/cronscripts":
    ensure  => directory,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0755',
    require => Users::Create['jtv']
  }

  file { '/home/jtv/.ssh/authorized_keys':
    owner   => 'jtv',
    group   => 'jtv',
    mode    => 0600,
    content => template('twitch/authorized_keys.erb'),
    require => Users::Create['jtv'],
  }
}
