class twitch::users::postgres (
  $password            = undef,
  $home                = '/var/lib/postgresql',
  $ssh_authorized_keys = [
    'countessdb',
    'infradb1 postgres',
    'jtv@puppet postgres',
    'sitedb',
  ],
  $ssh_priv_keys       = [
  ],
  $ssh_config_opts     = {}
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  users::create { 'postgres':
    home                => $home,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    ssh_config_opts     => $ssh_config_opts,
  }
}
