class twitch::vhosts::admin (
  $svc_name = 'stagingadmin',
  $vhost      = 'admin-staging.twitch.tv',
  $site_vhost = 'staging.twitch.tv',
  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
  $appcache_port = 2200,
) {

  validate_string($svc_name)
  validate_string($vhost)
  validate_string($site_vhost)

  $validate_appcache_port = is_numeric($appcache_port)
  validate_bool($validate_appcache_port)

  include twitch_nginx
  include twitch::nginxips
  include twitch::sites::config::web

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/vhosts/twitchadmin.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
