class twitch::vhosts::api_justintv (
  $svc_name = 'api_justintv',
  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir
) {

  include twitch_nginx
  include twitch::nginxips
  include twitch::sites::config::web
  include twitch::sites::config::upstream_usher
  include twitch::sites::config::upstream_newjtv

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/vhosts/${svc_name}.conf",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
