class twitch::vhosts::api_twitchtv (
  $svc_name               = 'twitchtv',
  $document_root          = '/home/jtv/staging/current/public',
  $api_hostname           = 'stagingapi.twitch.tv',
  $kraken_port            = 2200,
  $appcache_port          = 2200,
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
) {

  validate_string($svc_name)
  validate_string($api_hostname)
  validate_absolute_path($document_root)
  validate_absolute_path($vhost_dir)
  validate_re($kraken_port,'\d+')
  validate_re($appcache_port,'\d+')

  include twitch_nginx
  include twitch::sites::config::web
  include twitch::sites::config::upstream_kraken
  include twitch::sites::config::upstream_usher
  include twitch::sites::config::upstream_appcache
  include twitch::sites::config::twitchtv_acl

  file { "${vhost_dir}/api_${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/vhosts/api_twitchtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web'],Class['twitch::sites::config::twitchtv_acl']]
  }
}
