class twitch::vhosts::apiint (
  $svc_name = 'apiint',
  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir
) {

  include twitch_nginx
  include twitch::nginxips
  include twitch::sites::config::web

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/vhosts/${svc_name}.conf",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs'],
  }
}
