class twitch::vhosts::fan (
  $svc_name = 'fan',
  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
) {

  validate_string($svc_name)
  validate_absolute_path($vhost_dir)

  include twitch_nginx

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitch/vhosts/fan.conf',
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
