class twitch::vhosts::jobs_twitchtv (
  $svc_name               = 'twitchtv',
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
) {

  validate_string($svc_name)
  validate_absolute_path($vhost_dir)

  include twitch_nginx
  include twitch::sites::config::web

  file { "${vhost_dir}/jobs_${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => 'puppet:///modules/twitch/vhosts/jobs_twitchtv.conf',
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web']]
  }
}
