class twitch::vhosts::justintv (
  $svc_name = 'justintv'
) {

  include twitch_nginx
  include twitch::sites::config::web
  include twitch::sites::config::upstream_wwwjustintv
  include twitch::sites::config::upstream_newjtv

  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir
  $conf_dir = $twitch_nginx::params::nginx_conf_dir

  file { "${vhost_dir}/${svc_name}.conf":
    ensure       => present,
    owner        => 'root',
    group        => 'root',
    mode         => '0644',
    source       => "puppet:///modules/${module_name}/vhosts/${svc_name}.conf",
    notify       => Class['twitch_nginx::service'],
    require      => [Class['twitch_nginx::config_dirs'], File["${conf_dir}/${svc_name}_acl.conf"]],
  }

  file { "${conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/nginx/nginx_${cluster}_acl.conf",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
