class twitch::vhosts::secure_twitchtv (
  $svc_name               = 'twitchtv',
  $document_root          = '/home/jtv/staging/current/public',
  $secure_hostname        = 'secure.twitch.tv',
  $twitch_code_location   = '/home/jtv/staging',
  $appcache_port          = 2200,
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
) {

  validate_string($svc_name)
  validate_string($secure_hostname)
  validate_absolute_path($document_root)
  validate_absolute_path($vhost_dir)
  validate_absolute_path($twitch_code_location)
  validate_re($appcache_port,'\d+')

  include twitch_nginx
  include twitch::sites::config::web
  include twitch::sites::config::upstream_appcache

  file { "${vhost_dir}/secure_${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/vhosts/secure_twitchtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web']]
  }
}
