class twitch::vhosts::securejtvnw (
  $svc_name = 'securejtvnw',
  $vhost_dir = $twitch_nginx::params::nginx_vhost_dir,
) inherits twitch::params {
  validate_string($svc_name)
  validate_absolute_path($vhost_dir)

  include twitch_nginx
  include twitch::nginxips
  include twitch::sites::config::web
  include twitch::sites::config::twitchtv_acl

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    source  => "puppet:///modules/${module_name}/vhosts/${svc_name}.conf",
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web'],Class['twitch::sites::config::twitchtv_acl']]
  }
}
