class twitch::vhosts::store_twitchtv (
  $svc_name               = 'twitchtv',
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
  $conf_dir               = $twitch_nginx::params::nginx_conf_dir
) {

  validate_string($svc_name)
  validate_absolute_path($vhost_dir)
  validate_absolute_path($conf_dir)

  include twitch_nginx
  include twitch::sites::config::web

  file { "${vhost_dir}/store_${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/vhosts/store_twitchtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web']]
  }
}
