class twitch::vhosts::twitchtv (
  $svc_name = 'twitchtv',
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $document_root          = '/opt/twitch/web/current/public',
  $additional_hostnames   = 'staging.twitch.tv',
  $admin_vhost            = 'admin-staging.twitch.tv',
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
  $conf_dir               = $twitch_nginx::params::nginx_conf_dir
) {

  validate_string($svc_name)
  validate_string($additional_hostnames)
  validate_string($admin_vhost)
  validate_absolute_path($twitch_player_location)
  validate_absolute_path($twitch_code_location)
  validate_absolute_path($tmi_client_location)
  validate_absolute_path($document_root)

  include twitch_nginx
  include twitch::sites::config::web
  include twitch::sites::config::twitchtv_acl
  include twitch::sites::config::upstream_appcache
  include twitch::sites::config::upstream_discovery

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch/vhosts/twitchtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],Class['twitch::sites::config::web'],Class['twitch::sites::config::twitchtv_acl']]
  }
}
