##TODO: Did not see the usage of $kraken_port, $twice_port may be re-factored out, leaving for reference
class twitch::vhosts::wwwcdn (
  $svc_name               = 'wwwcdnbeta',
  $justin_player_location = '/opt/twitch/jtv_player',
  $twitch_player_location = '/opt/twitch/twitch_player',
  $twitch_code_location   = '/opt/twitch/web',
  $tmi_client_location    = '/opt/twitch/tmi_client',
  $document_root          = '/opt/twitch/web/current/public',
  $jtv_root               = '/opt/twitch/jtv-root',
  $service_hostname       = 'www-cdn-beta.jtvnw.net',
  $twice_port             = 3502,
  $kraken_port            = 3502,
  $vhost_dir              = $twitch_nginx::params::nginx_vhost_dir,
  $conf_dir               = $twitch_nginx::params::nginx_conf_dir
) {

  validate_string($svc_name)
  validate_absolute_path($justin_player_location)
  validate_absolute_path($twitch_player_location)
  validate_absolute_path($twitch_code_location)
  validate_absolute_path($tmi_client_location)
  validate_absolute_path($document_root)
  validate_absolute_path($vhost_dir)
  validate_absolute_path($conf_dir)
  validate_string($service_hostname)

  $validate_twice_port = is_numeric($twice_port)
  validate_bool($validate_twice_port)

  $validate_kraken_port = is_numeric($kraken_port)
  validate_bool($validate_kraken_port)

  include twitch_nginx
  include twitch::sites::config::web
  include twitch::sites::config::upstream_twice

  file { "${vhost_dir}/${svc_name}.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    content => template('twitch/vhosts/wwworiginjtv.conf.erb'),
    notify  => Class['twitch_nginx::service'],
    require => [Class['twitch_nginx::config_dirs'],File["${conf_dir}/${svc_name}_acl.conf"]],
  }

  file { "${conf_dir}/${svc_name}_acl.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/twitch/nginx/nginx_${cluster}_acl.conf",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
