# == Define: twitch_haproxy::global
#
# Begins the haproxy config for an instance
# Writes the global and default sections
#
# === Parameters
#
# [*global_options*]
#  Hash of options that will create global section of config, Default: <required>
#
# [*defaults_options*]
#  Hash of options that will create defaults section of config, Default: <required>
#
# [*config_target*]
#  Config file that will start the concat, Default: /etc/haproxy/haproxy.cfg
#
define twitch_haproxy::global (
  $global_options,
  $defaults_options,
  $config_target  = '/etc/haproxy/haproxy.cfg',
){

  validate_hash($global_options)
  validate_hash($defaults_options)

  concat { $config_target:
    owner => '0',
    group => '0',
    mode  => '0644',
  }

  # Simple Header
  concat::fragment { "00-header-${name}":
    target  => $config_target,
    order   => '01',
    content => "# This file managed by Puppet\n",
  }

  # Template uses $global_options, $defaults_options
  concat::fragment { "haproxy-base-${name}":
    target  => $config_target,
    order   => '10',
    content => template('twitch_haproxy/haproxy-base.cfg.erb'),
  }
}
