# == Class: twitch_haproxy
#
# Installs haproxy and creates conf directory and chroot directory
#
# === Parameters
#
# [*haproxy_version*]
#  Installs specific version of haproxy with package resource, Default: <see params.pp>
#
# [*haproxy_chroot_dir*]
#  Chroot directory for haproxy, Default: /var/chroot/haproxy
#
# [*haproxy_conf_dir*]
#  Config directory for haproxy, Default: /etc/haproxy
#
class twitch_haproxy (
  $haproxy_version    = $twitch_haproxy::params::haproxy_version,
  $haproxy_chroot_dir = $twitch_haproxy::params::haproxy_chroot_dir,
  $haproxy_conf_dir   = $twitch_haproxy::params::haproxy_conf_dir,
) inherits twitch_haproxy::params {

  include 'core::dirs'

  package{ 'haproxy':
    ensure => $haproxy_version,
  }

  file{ $haproxy_chroot_dir:
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => [Package['haproxy'],Class['core::dirs']],
  }

  file{ $haproxy_conf_dir:
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Package['haproxy'],
  }
}
