# == Class: twitch_haproxy::params
#
# This is a container class holding default parameters for for haproxy class.
#  currently, only the Redhat family is supported, but this can be easily
#  extended by changing package names and configuration file paths.
#
class twitch_haproxy::params {
  case $::osfamily {
    'Archlinux', 'Debian', 'Redhat': {
      $package_name     = 'haproxy'
      $global_options   = {
        'log'     => "${::ipaddress} local0",
        'chroot'  => '/var/lib/haproxy',
        'pidfile' => '/var/run/haproxy.pid',
        'maxconn' => '4000',
        'user'    => 'www-data',
        'group'   => 'www-data',
        'daemon'  => '',
        'quiet'   => '',
        'stats'   => 'socket /var/lib/haproxy/stats'
      }
      $defaults_options = {
        'log'     => 'global',
        'balance' => 'roundrobin',
        'option'  => [
          'redispatch',
          'tcplog',
          'tcpka',
          'contstats'
        ],
        'timeout' => [
          'connect 10s',
          'client 1m',
          'server 1m',
        ],
      }
    }
    default: { fail("The ${::osfamily} operating system is not supported with the haproxy module") }
  }

  $haproxy_chroot_dir = '/var/chroot/haproxy'
  $haproxy_conf_dir = '/etc/haproxy'

  $haproxy_version = $::lsbdistcodename ? {
    lucid    => '1.4.23-5lucid',
    precise  => '1.4.23-5precise',
    intrepid => '1.4.19-3intrepid',
    default  => absent
  }
}
