require 'spec_helper'

describe 'twitch_haproxy', :type => :class do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:params) do {
      :haproxy_version    => 'latest',
      :haproxy_chroot_dir => '/tmp/haproxy',
      :haproxy_conf_dir   => '/tmp/haproxy_conf',
    }
    end

    it "does contain Package['haproxy']" do
      should contain_package('haproxy').with({
        :ensure => params[:haproxy_version],
      })
    end

    it "does contain directory /tmp/haproxy" do
      should contain_file(params[:haproxy_chroot_dir]).with({
        :ensure => 'directory',
        :owner  => 'root',
        :group  => 'root',
      })
    end

    it "does contain directory /tmp/haproxy_conf" do
      should contain_file(params[:haproxy_conf_dir]).with({
        :ensure => 'directory',
        :owner  => 'root',
        :group  => 'root',
      })
    end
  end
end
