require 'spec_helper'

describe 'twitch_haproxy::frontend', :type => :define do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:title) { 'mytest' }
    let(:params) do {
      :ports             => 80,
      :config_target     => '/tmp/haproxy/haproxy.cfg',
    }
    end

    it "does contain concat::fragment for backend server config" do
      should contain_concat__fragment("#{title}_frontend_block").with({
        :target  => params[:config_target],
      })
    end

  end
end
